// programme emetteur RC5


#pragma chip PIC16F873
#pragma config |= 0xb72

#define FOSC 12000000
#define BAUD 9600

uns8 timer_ticker;
bit flag_timer;
bit f_38k;

#pragma bit IR1 @ PORTB.7
#pragma bit IR2 @ PORTB.6

#define Touche0 0b11000000010110

#include "interrupt.c"
#include "uart.c"


void sendRC5(uns16 code)                // envoi d'un code RC5
{
  uns8 compteur,j;
  uns16 irc5;

for (j=1;j<10;j++)                      // on envoie le mme code 10 fois
  {
  compteur=0;

  TMR0=0;
  timer_ticker=0;
  while (!flag_timer);
  flag_timer=0;
  do  {
      if ((code&8192)==8192) f_38k=0;   // le code est sur 16 bits avec 14 bits utiles
      else                   f_38k=1;   // f_38k autorise la porteuse  36 khz
      while(!flag_timer);               // pendant 0,889 mS
      flag_timer=0;
      if ((code&8192)==8192) f_38k=1;   // et l'autre periode est l'oppos
      else                   f_38k=0;
      code<<=1;                         // on fait une rotation pour le bit suivant
      compteur++;
      while (!flag_timer);
      flag_timer=0;
      }
  while (compteur<14);
  f_38k=0;
  for (irc5=1;irc5<7100;irc5++);        // et on temporise 88,889 mS entre chaque trame
  }
}


void main(void)
{
  uns16 i,j;

  f_38k=0;
  TRISB=0x00;
  PORTB=0;
  setup_UART();
  OPTION=0;
  timer_ticker=0;                       // prescaler timer 0  0

  TMR0=0;                               // reset du timer 0
  T0IE=1;                               // autoriser les interruptions sur le timer 0
  TMR1ON=1;
  TMR1IE=1;
  RCIE=0;
  PEIE=1;
  GIE=1;

  while (1) {
            sendRC5(Touche0);
            for (i=1;i<5000;i++) for (j=1;j<5;j++);     // tempo pour a peu prs une seconde
            }
}
